/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.client;

import com.ibm.hsc.client.CDAddIP;
import com.ibm.hsc.client.CDDiscoverIP;
import com.ibm.hsc.client.CDWorkerThread;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class CDThreadPool {
    private CDWorkerThread[] _pool;
    private Vector _outData;
    private ThreadGroup _cdTG;
    private boolean _doneSubmitting;
    private boolean _stopAllCalled;
    private Vector _reqQueue;

    private CDThreadPool(int n, int n2) {
        int n3;
        this._pool = new CDWorkerThread[n];
        this._cdTG = new ThreadGroup("CecDiscovery");
        this._outData = new Vector();
        this._doneSubmitting = false;
        this._reqQueue = new Vector();
        this._stopAllCalled = false;
        for (n3 = 0; n3 < n; ++n3) {
            this._pool[n3] = n2 == 0 ? new CDDiscoverIP(this._cdTG, "discoverIPThread_" + n3, this._outData, this) : new CDAddIP(this._cdTG, "addIPThread_" + n3, this._outData, this);
        }
        n3 = 0;
        while (n3 == 0) {
            int n4 = 0;
            for (n4 = 0; n4 < n && this._pool[n4].isInitialized(); ++n4) {
            }
            if (n4 < n) continue;
            n3 = 1;
        }
        this.debug("TP:  Threadpool is ready for requests!!!");
        this._cdTG.list();
    }

    public static CDThreadPool create(int n, int n2) {
        System.err.println("| ThreadPool.creating threadpool of size " + n);
        CDThreadPool cDThreadPool = new CDThreadPool(n, n2);
        return cDThreadPool;
    }

    private void debug(String string) {
        System.err.println("| ThreadPool." + string);
    }

    public int cmdRequest(String[] stringArray) {
        int n = 0;
        int n2 = 0;
        for (n2 = 0; n2 < this._pool.length; ++n2) {
            if (!this._pool[n2].isAvailable()) continue;
            this._pool[n2].routeRequest(stringArray);
            break;
        }
        if (n2 == this._pool.length) {
            this.debug("executing request = " + stringArray[0]);
            this._reqQueue.addElement(stringArray);
        }
        return n;
    }

    public void doneSubmittingCmds() {
        this._doneSubmitting = true;
    }

    public synchronized String[] getQueuedRequest() {
        String[] stringArray = null;
        try {
            stringArray = (String[])this._reqQueue.remove(0);
            this.debug("dq'd request=" + stringArray[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return stringArray;
    }

    public void waitUntilAllFinished(int n) {
        while (!this._doneSubmitting) {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {}
        }
        boolean bl = false;
        String[] stringArray = null;
        while (!bl && !this._stopAllCalled) {
            boolean bl2 = false;
            for (int i = 0; i < this._pool.length; ++i) {
                if (!this._pool[i].isAlive() || this._pool[i].isAvailable()) continue;
                try {
                    if (stringArray == null) {
                        this.debug("Very 1st deadbeatdude: " + this._pool[i].getName());
                        stringArray = new String[]{this._pool[i].getName(), this._pool[i].getCmdArgs()[0], "" + System.currentTimeMillis()};
                    } else {
                        this.debug("comparing deadbeats " + stringArray[0].equals(this._pool[i].getName()) + " to " + stringArray[1].equals(this._pool[i].getCmdArgs()[0]));
                        if (!stringArray[0].equals(this._pool[i].getName()) || !stringArray[1].equals(this._pool[i].getCmdArgs()[0])) {
                            this.debug("Different deadbeatdude:  " + this._pool[i].getName());
                            stringArray[0] = this._pool[i].getName();
                            stringArray[1] = this._pool[i].getCmdArgs()[0];
                            stringArray[2] = "" + System.currentTimeMillis();
                        } else {
                            long l = Long.parseLong(stringArray[2]);
                            long l2 = System.currentTimeMillis() - Long.parseLong(stringArray[2]);
                            this.debug(" Ellapsed Time deadbeatdude " + this._pool[i].getName() + " = " + l2);
                            long l3 = (long)(n * 1000) * 2L;
                            if (l2 > l3) {
                                this.debug("exceeded maxTime = " + l3 + " interrupting thread...");
                                this._pool[i].interrupt();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                bl2 = true;
                this.debug(" WT " + this._pool[i].getName() + " is busy");
                this.debug(" WT " + this._pool[i].getName() + " processing " + this._pool[i].getCmdArgs()[0]);
                break;
            }
            if (this._reqQueue != null && this._reqQueue.size() > 0) {
                bl2 = true;
                this.debug("TP:   Request queue size > 0:  " + this._reqQueue.size());
            }
            if (!bl2) {
                bl = true;
                continue;
            }
            try {
                this.debug("Not done processing requests - sleeping 15000 ms");
                Thread.sleep(15000L);
            }
            catch (Throwable throwable) {}
        }
        this.debug("waitUntilAllFinished - returning - no more unserviced requests exist.");
    }

    public Vector getResultData() {
        return this._outData;
    }

    public void dispose() {
        this.stopAll();
        this._reqQueue = null;
        for (int i = 0; i < this._pool.length; ++i) {
            this._pool[i] = null;
        }
    }

    private void clearRequestQueue() {
        this._reqQueue.clear();
    }

    public void stopAll() {
        this._stopAllCalled = true;
        for (int i = 0; i < this._pool.length; ++i) {
            this._pool[i].setDone(true);
        }
        this._cdTG.interrupt();
        this.clearRequestQueue();
    }

    public void printStats() {
        System.out.println(" *****************************************");
        for (int i = 0; i < this._pool.length; ++i) {
            System.err.println("TP:  Worker Thread " + this._pool[i].getName() + " # serviced = " + this._pool[i].getNServiced());
        }
        System.err.println(" *****************************************");
    }

    public void printReqQueue() {
        int n = 0;
        Iterator iterator = this._reqQueue.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            System.err.println("TP:   reqQueue[ " + n++ + " = " + stringArray[0]);
        }
    }

    public void printTimeStamp(String string) {
        Date date = new Date(System.currentTimeMillis());
        System.err.println(string);
        System.err.println("TP:  Current time is:  " + date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds());
    }

    public void printTimeDiff(String string, long l) {
        Date date = new Date(l);
        System.err.println(string);
        System.err.println(">>>>>>>>>>>>> Total ellapsed time:  " + date.getMinutes() + " minutes " + date.getSeconds() + " seconds  <<<<<<<<<<<<<<.");
    }

    public static void main(String[] stringArray) {
        int n = 10;
        CDThreadPool cDThreadPool = null;
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n2 = 10;
        int n3 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println("args[" + i + "] = " + stringArray[i]);
        }
        try {
            n2 = Integer.parseInt(stringArray[2]);
            n3 = Integer.parseInt(stringArray[3]);
        }
        catch (Throwable throwable) {
            System.err.println("JPD:  number of threads arg is not a number...");
            System.exit(1);
        }
        System.out.println("beg IP        = " + string);
        System.out.println("end IP        = " + string2);
        System.out.println("# threads     = " + n2);
        System.out.println("delay b4 stop (in millis) = " + n3);
        int n4 = 0;
        try {
            n4 = Integer.parseInt(string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("JPD:  endIPAddr is not a number.");
            System.exit(1);
        }
        cDThreadPool = CDThreadPool.create(n2, 0);
        for (int i = 0; i < n4; ++i) {
            String[] stringArray2 = new String[]{string + "." + i, "n/a"};
            System.out.println("JPD:  Submitting  ipaddr = " + stringArray2[0]);
            cDThreadPool.cmdRequest(stringArray2);
        }
        cDThreadPool.doneSubmittingCmds();
        System.out.println("done submitting cmds...");
        cDThreadPool.waitUntilAllFinished(300000);
        System.out.println("All cmds finished...");
        Vector vector = cDThreadPool.getResultData();
        int n5 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String[] stringArray3 = (String[])iterator.next();
            System.out.println("JPD:  results Vector [" + n5++ + "] = " + stringArray3[0] + " " + stringArray3[1]);
        }
        cDThreadPool.printReqQueue();
        cDThreadPool.printStats();
        cDThreadPool.dispose();
    }
}

